

/******************************************************************************************
 *                                                                                        *
 *  Ex2.     :  Read ASCII ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                  *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *              
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
  * Target MCU       : PIC18F8722 (ET-BASE PIC8722(ICD2))                                 *
 *                   : X-TAL : 10 MHz                                                     *
 *                   : CPU Clock = 40 MHz (x4)                                            *  
 *                                                                                        *
 * Editor-Compiler   : CCS Version 4.124                                                  *
 *                                                                                        *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 13/April/2015                                                      *
 *                                                                                        *
 * Port Interface    :  -- MCU-PIC-18F8722--                                              *
 *                                                                                        *
 * I/P UART1(Driver) :  RC6 = TX1          Connect           Rx ET-Matrix Key Decoder     *
 *                      RC7 = RX1          Connect           Tx ET-Matrix Key Decoder     *                                                                        *
 *                      Baud Rate = 57600  at Clock 40Mhz                                 *
 *                                                                                        *
 *   O/P DISPLAY Port :                                                                   *
 *                                                                                        *  
 *                LED :Connect Common Anode(LED Active Low)                               *
 *                     RB0..RB7(Output)     Connect           LED0..LED7                  *
 *                                                                                        *
 *                                                                             5V         *
 *                                                                             -+-        *
 *                                                              560      \\     |         *
 *                                                      RB0 --/\/\/\---|<|------+         *
 *                                                                      .       |         *
 *                                                              560     . \\    |         *
 *                                                      RB7 --/\/\/\---|<|------+         *
 *                                                                                        *
 *                                                                                        *
 *   Operation  : When Press Key will :                                                   *
 *                                      -Show ASCII(Hex) Key Code (Key0-F) To LED         *  
 *                                                                                        *
 ******************************************************************************************/
 

#include <18F8722.h>
#include <stdio.h>

//#define TX1   PIN_C6
//#define RX1   PIN_C7

#fuses H4,NOLVP,NOWDT,NOPROTECT,NOSTVREN           //Setup MCU
#use delay (clock = 40000000)                      //delay Clock = (ms)
//#use rs232(baud = 57600, xmit = TX1, rcv = RX1)  //Set Rs232
#use rs232(uart1,baud=57600,stream=ch1)            //Set Rs232 Hard ware
#use fast_io(ALL)                                  //Stop Set direction Auto for All Port  by Compiler  

int8 key[3] ,n=0                    ;

/*********************************************************
 **                                                     **
 **    Interrup Service Receive DATA Uart1 (RX1)        **
 **                                                     **
 *********************************************************/ 
 
#INT_RDA
void IntRDA_isr(void)
 {  
    
     key[n]   = getc()                 ;  //Step1: Read ASCII Code 3 Byte
     n++                               ;  //Pointer Array     

     if(n == 3)                           //if Pointer= 3 Clear Pointer=0
        n=0                            ;
   
 }
 
 

//*************************** Main *************************

void main (void) 
    {                               
     
     
     //------------- Initial Port -----------
      set_tris_B(0x00)                ;       //Set RB(0..7) = Output for LED Display ASCII(Hex) Key Code  
                
      OUTPUT_B(0xFF)                  ;       //Set data 0xFF Default RB = LED OFF  
      
     //---------initial Uart1 ------------

      set_tris_C(0x80)                ;       //Set RX(RC7) = In,TX(RC6)=Out,RC5..RC0 = Out
    
      enable_interrupts(GLOBAL)       ;
      enable_interrupts(INT_RDA)      ;
      
    //---------------- Main -----------------
    
      while(true)
       {
        if(key[2] == 0x0D)                    //Step2: Check data Last Byte = Enter ?            
         {
           key[2] = 0 ;                       //Step3: Clear data in buffer array key[2]
         
           if(key[0]=='P')                    //Step4: Check  Status  Pressed key (ASCII Code = 'P')
            {
             //------ Step5 : Write Program Support Press Key of User ------ 
                      
             OUTPUT_B(~key[1])          ;     //Out data Ascii(Hex) key Code to LED RB[0..5]
            
             while(key[0] != 'R') {;}         //wait Release Key (when key[0]=R) for Exit Loop   
           
             OUTPUT_B(0xFF)             ;     //Clear LED PORT RB0..RB7 -LED OFF
           }
         }  //if key[2]    
       } //while
    }


